pkgname = "libpng"
pkgver  = "1.6.50"
source  = f"https://downloads.sourceforge.net/libpng/libpng-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir -p {fembuilddir} && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --disable-static",
    f"cd {builddir} && make -j1",  # build without -j to ensure .so is created
    f"cd {builddir} && make install",
    f"cd {builddir} && mkdir -p /usr/share/doc/libpng-{pkgver}",
    f"cd {builddir} && cp -v README libpng-manual.txt /usr/share/doc/libpng-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
