pkgname =  "libportal"
pkgver  = "0.9.1" 
source  = f"https://github.com/flatpak/libportal/releases/download/{pkgver}/libportal-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "gtk3", "gtk4", "xdg-desktop-portal"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz && wget https://www.linuxfromscratch.org/patches/blfs/svn/libportal-{pkgver}-qt6.9_fixes-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../libportal-{pkgver}-qt6.9_fixes-1.patch && mkdir build && cd build && if [ -e /usr/include/libportal ]; then rm -rf /usr/include/libportal.old && mv -vf /usr/include/libportal{{,.old}}; fi && meson setup --prefix=/usr --buildtype=release -D vapi=false -D docs=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
