pkgname =  "libqalculate"
pkgver  = "5.8.0" 
source  = f"https://github.com/Qalculate/libqalculate/releases/download/v{pkgver}/libqalculate-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["curl", "icu"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --disable-static --docdir=/usr/share/doc/libqalculate-{pkgver}",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && rm -v /usr/lib/libqalculate.la",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
