pkgname =  "librsvg"
pkgver  = "2.61.1" 
source  = f"https://download.gnome.org/sources/librsvg/2.61/librsvg-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cairo", "cargo-c", "gdkpixbuf", "pango", "glib", "vala"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed -e \"/OUTDIR/s|,| / 'librsvg-{pkgver}', '--no-namespace-dir',|\" -e '/output/s|Rsvg-2.0|librsvg-{pkgver}|' -i doc/meson.build && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
