pkgname =  "libsecret"
pkgver  = "0.21.7" 
source  = f"https://download.gnome.org/sources/libsecret/0.21/libsecret-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "libgcrypt", "gnutls", "vala"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir bld && cd bld && meson setup --prefix=/usr --buildtype=release -D gtk_doc=false ..",
    f"cd {builddir}/bld && ninja",
    f"cd {builddir}/bld && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
