pkgname =  "libsndfile"
pkgver  = "1.2.2" 
source  = f"https://github.com/libsndfile/libsndfile/releases/download/{pkgver}/libsndfile-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed '/typedef enum/,/bool ;/d' -i src/ALAC/alac_{{en,de}}coder.c && ./configure --prefix=/usr --docdir=/usr/share/doc/libsndfile-{pkgver}",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
