pkgname =  "libsoup"
pkgver  = "3.6.5" 
source  = f"https://download.gnome.org/sources/libsoup/3.6/libsoup-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "vala", "glib-networking", "libpsl", "nghttp2"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed 's/apiversion/soup_version/' -i docs/reference/meson.build && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release --wrap-mode=nofallback ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
