pkgname =  "libtiff"
pkgver  = "4.7.1" 
source  = f"https://download.osgeo.org/libtiff/tiff-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/tiff-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/tiff-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir libtiff-build && cd libtiff-build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_POLICY_VERSION_MINIMUM=3.5 -G Ninja -D CMAKE_INSTALL_DOCDIR=/usr/share/doc/libtiff-{pkgver} ..",
    f"cd {builddir}/libtiff-build && ninja",
    f"cd {builddir}/libtiff-build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
