pkgname =  "libva"
pkgver  = "2.22.0" 
source  = f"https://github.com/intel/libva/archive/{pkgver}/libva-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir}/build && meson setup .. --prefix=/usr -Ddisable_drm=false -Dwith_x11=yes -Dwith_glx=yes -Dwith_wayland=yes -Dwith_legacy=[] -Denable_docs=false --buildtype=release",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
