pkgname =  "libvorbis"
pkgver  = "1.3.7" 
source  = f"https://downloads.xiph.org/releases/vorbis/libvorbis-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libogg"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --disable-static",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && install -v -m644 doc/Vorbis* /usr/share/doc/libvorbis-{pkgver} || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
