pkgname =  "libwacom"
pkgver  = "2.16.1" 
source  = f"https://github.com/linuxwacom/libwacom/releases/download/libwacom-{pkgver}/libwacom-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libevdev", "libgudev", "libxml2"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D tests=disabled ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && rm -rf /usr/share/libwacom || true && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
