pkgname =  "libwebp"
pkgver  = "1.6.0" 
source  = f"https://storage.googleapis.com/downloads.webmproject.org/releases/webp/libwebp-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libjpeg-turbo", "libpng", "libtiff", "sdl2"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --enable-libwebpmux --enable-libwebpdemux --enable-libwebpdecoder --enable-libwebpextras --enable-swap-16bit-csp --disable-static",
    f"cd {builddir} && make",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
