pkgname =  "libxau"
pkgver  = "1.0.12" 
source  = f"https://www.x.org/pub/individual/lib/libXau-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/libXau-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["xorgproto"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/libXau-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && export XORG_PREFIX=\"/usr\" && mkdir build && cd build && meson setup .. --prefix=$XORG_PREFIX --sysconfdir=/etc --localstatedir=/var",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
