pkgname = "libxcrypt"
pkgver  = "4.4.38"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --enable-hashes=strong,glibc --enable-obsolete-api=no --disable-static --disable-failure-tokens",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make check -j$(nproc) || true",
    f"cd /sources/{pkgname}-{pkgver} && make install",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && make distclean",
    f"cd /sources/{pkgname}-{pkgver} && CC=\"gcc -m32\" ./configure --prefix=/usr --host=i686-pc-linux-gnu --libdir=/usr/lib32 --enable-hashes=strong,glibc --enable-obsolete-api=glibc --disable-static --disable-failure-tokens",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && cp -av .libs/libcrypt.so* /usr/lib32/ && make install-pkgconfigDATA && ln -svf libxcrypt.pc /usr/lib32/pkgconfig/libcrypt.pc",
    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
