pkgname =  "libxdmcp"
pkgver  = "1.1.5" 
source  = f"https://www.x.org/pub/individual/lib/libXdmcp-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/libXdmcp-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["xorgproto"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/libXdmcp-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && export XORG_PREFIX=\"/usr\" && export XORG_CONFIG=\"--prefix=$XORG_PREFIX --sysconfdir=/etc --localstatedir=/var --disable-static\" && ./configure $XORG_CONFIG --docdir=/usr/share/doc/libXdmcp-{pkgver}",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
