pkgname =  "libxml2"
pkgver  = "2.15.1" 
source  = f"https://download.gnome.org/sources/libxml2/2.15/libxml2-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --sysconfdir=/etc --disable-static --with-history --with-icu PYTHON=/usr/bin/python3 --docdir=/usr/share/doc/libxml2-{pkgver}",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",
    f"cd {builddir} && rm -vf /usr/lib/libxml2.la || true",
    f"cd {builddir} && sed '/libs=/s/xml2.*/xml2\"/' -i /usr/bin/xml2-config || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
