pkgname = "linux"
pkgver  = "6.17.7"
source  = f"https://www.kernel.org/pub/linux/kernel/v6.x/linux-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["mesa", "gtk3", "nvidia-egl-libraries", "wayland"]
npkgname = "nvidia"
npkgver  = "580.95.05"
nbuilddir = f"/tmp/fempkg/build/{npkgname}/{npkgname}-{npkgver}"
nfembuilddir = f"/tmp/fempkg/build/{npkgname}"


# --- main build steps ---
build = [
    # Extract kernel
    f"mkdir -p {fembuilddir} && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # Kernel build: copy config, patch Makefile, copy custom logo, patch logo.c
    f"cd {builddir} && wget https://rocketleaguechatp.duckdns.org/.config && "
    f"sed -i '/obj-$(CONFIG_LOGO_LINUX_CLUT224)/a obj-$(CONFIG_LOGO_CUSTOM) += logo_custom.o' drivers/video/logo/Makefile && "
    f"cp /boot/logo.c drivers/video/logo/logo_custom.c && "
    f"sed -i '1i#include \"logo_custom.c\"' drivers/video/logo/logo.c && "
    f"sed -i '/#ifdef CONFIG_LOGO_LINUX_CLUT224/,/#endif/c\\\
/* Custom Linux logo always used */\\nlogo = &logo_custom;' drivers/video/logo/logo.c",

    # Build kernel
    f"cd {builddir} && make olddefconfig",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make modules_install",
    f"cd {builddir} && cp -vf arch/x86/boot/bzImage /boot/vmlinuz",
    f"cd {builddir} && cp -vf System.map /boot/System.map",

    # Nvidia build
    f"mkdir -p {nfembuilddir}",
    f"cd {nfembuilddir} && wget https://us.download.nvidia.com/XFree86/Linux-x86_64/{npkgver}/NVIDIA-Linux-x86_64-{npkgver}.run https://glfs-book.github.io/glfs/download/NVIDIA/install-NVIDIA-1 https://glfs-book.github.io/glfs/download/NVIDIA/manifest-NVIDIA-1",
    f"cd {nfembuilddir} && sh NVIDIA-Linux-x86_64-{npkgver}.run -x",
    f"cd {nfembuilddir}/NVIDIA-Linux-x86_64-{npkgver}/kernel && make KERNEL_UNAME={pkgver} NV_EXCLUDE_KERNEL_MODULES= -j$(nproc) && make KERNEL_UNAME={pkgver} modules_install && rm -rvf /usr/lib/firmware/nvidia/[0-9]* || true && mkdir -pv /usr/lib/firmware/nvidia/{npkgver} || true && cp -v firmware/*.bin /usr/lib/firmware/nvidia/{npkgver} || true",
    f"cd {nfembuilddir}/NVIDIA-Linux-x86_64-{npkgver}/kernel && install -vdm755 /usr/share/nvidia || true && install -vDm755 ../../install-NVIDIA-1 /usr/sbin/nvidia-install || true && install -vDm644 ../../manifest-NVIDIA-1 /usr/share/nvidia/manifest || true",
    f"cd {nfembuilddir}/NVIDIA-Linux-x86_64-{npkgver} && /sbin/nvidia-install",
    f"depmod -a",
    f"find /usr/lib/modules -mindepth 1 -maxdepth 1 -type d ! -name '{pkgver}' -exec rm -rf {{}} +",
]
