pkgname =  "llvm"
pkgver  = "21.1.2" 
source  = f"https://github.com/llvm/llvm-project/releases/download/llvmorg-{pkgver}/llvm-{pkgver}.src.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}.src"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && wget https://anduin.linuxfromscratch.org/BLFS/llvm/llvm-cmake-{pkgver}.src.tar.xz https://anduin.linuxfromscratch.org/BLFS/llvm/llvm-third-party-{pkgver}.src.tar.xz https://github.com/llvm/llvm-project/releases/download/llvmorg-{pkgver}/clang-{pkgver}.src.tar.xz https://github.com/llvm/llvm-project/releases/download/llvmorg-{pkgver}/compiler-rt-{pkgver}.src.tar.xz && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.src.tar.xz",

    # 64-bit build
    f"cd {builddir} && tar -xf ../llvm-cmake-{pkgver}.src.tar.xz",
    f"cd {builddir} && tar -xf ../llvm-third-party-{pkgver}.src.tar.xz",
    f"cd {builddir} && sed '/LLVM_COMMON_CMAKE_UTILS/s@../cmake@cmake-{pkgver}.src@' -i CMakeLists.txt",
    f"cd {builddir} && sed '/LLVM_THIRD_PARTY_DIR/s@../third-party@third-party-{pkgver}.src@' -i cmake/modules/HandleLLVMOptions.cmake",
    f"cd {builddir} && tar -xf ../clang-{pkgver}.src.tar.xz -C tools",
    f"cd {builddir} && mv tools/clang-{pkgver}.src tools/clang",
    f"cd {builddir} && tar -xf ../compiler-rt-{pkgver}.src.tar.xz -C projects",
    f"cd {builddir} && mv projects/compiler-rt-{pkgver}.src projects/compiler-rt",
    f"cd {builddir} && grep -rl '#!.*python' | xargs sed -i '1s/python$/python3/'",
    f"cd {builddir} && sed 's/utility/tool/' -i utils/FileCheck/CMakeLists.txt",
    f"cd {builddir} && mkdir -v build && cd build",
    f"cd {builddir}/build && CC=gcc CXX=g++ cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_SKIP_INSTALL_RPATH=ON -D LLVM_ENABLE_FFI=ON -D CMAKE_BUILD_TYPE=Release -D LLVM_BUILD_LLVM_DYLIB=ON -D LLVM_LINK_LLVM_DYLIB=ON -D LLVM_ENABLE_RTTI=ON -D LLVM_TARGETS_TO_BUILD=\"host;AMDGPU\" -D LLVM_BINUTILS_INCDIR=/usr/include -D LLVM_INCLUDE_BENCHMARKS=OFF -D CLANG_DEFAULT_PIE_ON_LINUX=ON -D CLANG_CONFIG_FILE_SYSTEM_DIR=/etc/clang -W no-dev -G Ninja ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",


    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
