pkgname =  "lua"
pkgver  = "5.4.8" 
source  = f"https://www.lua.org/ftp/lua-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz && wget https://www.linuxfromscratch.org/patches/blfs/svn/lua-{pkgver}-shared_library-1.patch",

    # 64-bit build
    f"""cd {builddir} && cat > lua.pc << "EOF"
V=5.4
R={pkgver}

prefix=/usr
INSTALL_BIN=${{prefix}}/bin
INSTALL_INC=${{prefix}}/include
INSTALL_LIB=${{prefix}}/lib
INSTALL_MAN=${{prefix}}/share/man/man1
INSTALL_LMOD=${{prefix}}/share/lua/${{V}}
INSTALL_CMOD=${{prefix}}/lib/lua/${{V}}
exec_prefix=${{prefix}}
libdir=${{exec_prefix}}/lib
includedir=${{prefix}}/include

Name: Lua
Description: An Extensible Extension Language
Version: ${{R}}
Requires:
Libs: -L${{libdir}} -llua -lm -ldl
Cflags: -I${{includedir}}
EOF""",
    f"cd {builddir} && patch -Np1 -i ../lua-{pkgver}-shared_library-1.patch && make linux -j$(nproc)",
    f"cd {builddir} && make INSTALL_TOP=/usr INSTALL_DATA=\"cp -d\" INSTALL_MAN=/usr/share/man/man1 TO_LIB=\"liblua.so liblua.so.5.4 liblua.so.{pkgver}\" install && mkdir -pv /usr/share/doc/lua-{pkgver} && cp -v doc/*.{{html,css,gif,png}} /usr/share/doc/lua-{pkgver} && install -v -m644 -D lua.pc /usr/lib/pkgconfig/lua.pc",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
