# lz4.recipe.py
pkgname = "lz4"
pkgver  = "1.10.0"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && make BUILD_STATIC=no PREFIX=/usr -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make BUILD_STATIC=no PREFIX=/usr install",

    # Clean for 32-bit
    f"cd /sources/{pkgname}-{pkgver} && make clean || true",
    f"cd /sources/{pkgname}-{pkgver} && rm -f config.log",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && CC=\"gcc -m32\" make BUILD_STATIC=no -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make BUILD_STATIC=no PREFIX=/usr LIBDIR=/usr/lib32 DESTDIR=$(pwd)/m32 install",
    f"cd /sources/{pkgname}-{pkgver} && cp -a m32/usr/lib32/* /usr/lib32/",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
