pkgname =  "mesa"
pkgver  = "25.2.2" 
source  = f"https://mesa.freedesktop.org/archive/mesa-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["xorg-libs", "libdrm", "glslang", "mako", "pyyaml", "cbindgen", "libclc", "libglvnd", "libvdpau", "llvm", "ply", "wayland-protocols", "vulkan-loader", "rustbindgen"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D glvnd=enabled -D platforms=x11,wayland -D gallium-drivers=auto -D vulkan-drivers=auto -D valgrind=disabled -D video-codecs=all -D libunwind=disabled",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
