pkgname = "meson"
pkgver  = "1.9.1" 
source  = f"https://github.com/mesonbuild/meson/releases/download/{pkgver}/meson-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && pip3 wheel -w dist --no-cache-dir --no-build-isolation --no-deps $PWD",
    f"cd {builddir} && pip3 install --no-index --find-links dist meson",
    f"cd {builddir} && install -vDm644 data/shell-completions/bash/meson /usr/share/bash-completion/completions/meson || true",
    f"cd {builddir} && install -vDm644 data/shell-completions/zsh/_meson /usr/share/zsh/site-functions/_meson || true",
    
    # Cleanup
    f"rm -rf {fembuilddir}"
]
