pkgname =  "meson_python"
pkgver  = "0.18.0" 
source  = f"https://files.pythonhosted.org/packages/source/m/meson_python/meson_python-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["patchelf", "pyproject_metadata"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD",
    f"cd {builddir} && pip3 install --no-index --find-links dist --no-user meson_python",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
