# mpc.recipe.py
pkgname = "mpc"
pkgver  = "1.3.1"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",
    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --disable-static --docdir=/usr/share/doc/mpc-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make html",
    f"cd /sources/{pkgname}-{pkgver} && make check -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",
    f"cd /sources/{pkgname}-{pkgver} && make install-html",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
