# mpfr.recipe.py
pkgname = "mpfr"
pkgver  = "4.2.2"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --disable-static --enable-thread-safe --docdir=/usr/share/doc/mpfr-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make html",
    f"cd /sources/{pkgname}-{pkgver} && make check -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",
    f"cd /sources/{pkgname}-{pkgver} && make install-html",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
