pkgname = "ncurses"
pkgver  = "6.5-20250809"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tgz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tgz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --mandir=/usr/share/man --with-shared --without-debug --without-normal --with-cxx-shared --enable-pc-files --with-pkg-config-libdir=/usr/lib/pkgconfig",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make DESTDIR=$PWD/dest install",
    f"cd /sources/{pkgname}-{pkgver} && sed -e 's/^#if.*XOPEN.*$/#if 1/' -i dest/usr/include/curses.h",
    f"cd /sources/{pkgname}-{pkgver} && cp --remove-destination -av dest/* /",
    f"cd /sources/{pkgname}-{pkgver} && for lib in ncurses form panel menu; do ln -sfv lib${{lib}}w.so /usr/lib/lib${{lib}}.so; ln -sfv ${{lib}}w.pc /usr/lib/pkgconfig/${{lib}}.pc; done",
    f"cd /sources/{pkgname}-{pkgver} && ln -sfv libncursesw.so /usr/lib/libcurses.so",
    f"cd /sources/{pkgname}-{pkgver} && cp -v -R doc -T /usr/share/doc/ncurses-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && make distclean",
    f"cd /sources/{pkgname}-{pkgver} && CC=\"gcc -m32\" CXX=\"g++ -m32\" ./configure --prefix=/usr --host=i686-pc-linux-gnu --libdir=/usr/lib32 --mandir=/usr/share/man --with-shared --without-debug --without-normal --with-cxx-shared --enable-pc-files --with-pkg-config-libdir=/usr/lib32/pkgconfig",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make DESTDIR=$PWD/DESTDIR install",
    f"cd /sources/{pkgname}-{pkgver} && mkdir -p DESTDIR/usr/lib32/pkgconfig",
    f"cd /sources/{pkgname}-{pkgver} && for lib in ncurses form panel menu; do rm -vf DESTDIR/usr/lib32/lib${{lib}}.so; echo \"INPUT(-l${{lib}}w)\" > DESTDIR/usr/lib32/lib${{lib}}.so; ln -svf ${{lib}}w.pc DESTDIR/usr/lib32/pkgconfig/$lib.pc; done",
    f"cd /sources/{pkgname}-{pkgver} && rm -vf DESTDIR/usr/lib32/libcursesw.so",
    f"cd /sources/{pkgname}-{pkgver} && echo \"INPUT(-lncursesw)\" > DESTDIR/usr/lib32/libcursesw.so",
    f"cd /sources/{pkgname}-{pkgver} && ln -sfv libncurses.so DESTDIR/usr/lib32/libcurses.so",
    f"cd /sources/{pkgname}-{pkgver} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd /sources/{pkgname}-{pkgver} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
