pkgname =  "nettle"
pkgver  = "3.10.2" 
source  = f"https://ftp.gnu.org/gnu/nettle/nettle-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --disable-static",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && chmod -v 755 /usr/lib/lib{{hogweed,nettle}}.so && install -v -m755 -d /usr/share/doc/nettle-{pkgver} && install -v -m644 nettle.{{html,pdf}} /usr/share/doc/nettle-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
