pkgname =  "newt"
pkgver  = "0.52.25" 
source  = f"https://releases.pagure.org/newt/newt-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["popt", "slang"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && sed -e '/install -m 644 $(LIBNEWT)/ s/^/#/' -e '/$(LIBNEWT):/,/rv/ s/^/#/' -e 's/$(LIBNEWT)/$(LIBNEWTSH)/g' -i Makefile.in && ./configure --prefix=/usr --with-gpm-support --with-python=python3.13",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
