pkgname = "ninja"
pkgver  = "1.13.1" 
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && python3 configure.py --bootstrap --verbose",
    f"cd /sources/{pkgname}-{pkgver} && install -vm755 ninja /usr/bin/ || true",
    f"cd /sources/{pkgname}-{pkgver} && install -vDm644 misc/bash-completion /usr/share/bash-completion/completions/ninja || true",
    f"cd /sources/{pkgname}-{pkgver} && install -vDm644 misc/zsh-completion  /usr/share/zsh/site-functions/_ninja || true",
    
    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
