pkgname =  "nodejs"
pkgver  = "22.20.0" 
source  = f"https://nodejs.org/dist/v{pkgver}/node-v{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/node-v{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["which", "brotli", "c-ares", "icu", "nghttp2"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/node-v{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --shared-brotli --shared-cares --shared-libuv --shared-openssl --shared-nghttp2 --shared-zlib --with-intl=system-icu",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && ln -sf node /usr/share/doc/node-{pkgver} || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
