pkgname =  "nvidia-egl-libraries"
pkgver  = "1.0" 
source  = f"https://github.com/NVIDIA/eglexternalplatform/archive/1.2.1/eglexternalplatform-1.2.1.tar.gz" #dymmy url
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["mesa", "libdrm", "libglvnd", "wayland", "wayland-protocols", "xorg-libs"]

build = [
    # Extract (create directories only, sources will be fetched in the loop)
    f"mkdir -pv /tmp/fempkg/build {fembuilddir} {builddir}",

    # Prepare list
    f"""cd {builddir} && cat > nvidia-egl-list << "EOF"
eglexternalplatform/archive/1.2.1/eglexternalplatform-1.2.1.tar.gz
egl-gbm/archive/1.1.2.1/egl-gbm-1.1.2.1.tar.gz
egl-wayland/archive/1.1.20/egl-wayland-1.1.20.tar.gz
egl-x11/archive/v1.0.3/egl-x11-1.0.3.tar.gz
EOF""",

    # Download, build, install
    f"""cd {builddir} && mkdir -p nvidia-egl && cd nvidia-egl && \
for package in $(grep -v '^#' ../nvidia-egl-list); do \
    url=https://github.com/NVIDIA/$package; \
    wget -c $url; \
    file=$(basename $package); \
    dir=${{file%.tar.?z*}}; \
    tar -xf $file; \
    pushd $dir; \
    mkdir -pv build; cd build; \
    meson setup --prefix=/usr --buildtype=release ..; \
    ninja; \
    ninja install; \
    popd; \
    rm -rf $dir; \
done && /sbin/ldconfig""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
