pkgname =  "openldap"
pkgver  = "2.6.10" 
source  = f"https://www.openldap.org/software/download/OpenLDAP/openldap-release/openldap-{pkgver}.tgz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cyrus-sasl"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tgz && wget https://www.linuxfromscratch.org/patches/blfs/svn/openldap-{pkgver}-consolidated-1.patch",

    # 64-bit build
    f"cd {builddir} && autoreconf && patch -Np1 -i ../openldap-{pkgver}-consolidated-1.patch && ./configure --prefix=/usr --sysconfdir=/etc --localstatedir=/var --libexecdir=/usr/lib --disable-static --disable-debug --with-tls=openssl --with-cyrus-sasl --without-systemd --enable-dynamic --enable-crypt --enable-spasswd --enable-slapd --enable-modules --enable-rlookups --enable-backends=mod --disable-sql --disable-wt --enable-overlays=mod",
    f"cd {builddir} && make depend -j$(nproc) && make -j$(nproc)",
    f"cd {builddir} && make install && sed -e \"s/\\.la/.so/\" -i /etc/openldap/slapd.{{conf,ldif}}{{,.default}} && install -v -dm700 -o ldap -g ldap /var/lib/openldap && install -v -dm700 -o ldap -g ldap /etc/openldap/slapd.d && chmod -v 640 /etc/openldap/slapd.{{conf,ldif}} && chown -v root:ldap /etc/openldap/slapd.{{conf,ldif}} && install -v -dm755 /usr/share/doc/openldap-{pkgver} && cp -vfr doc/{{drafts,rfc,guide}} /usr/share/doc/openldap-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
