pkgname = "openssl"
pkgver  = "3.6.0"
source  = f"https://github.com/openssl/openssl/releases/download/openssl-{pkgver}/openssl-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && ./config --prefix=/usr --openssldir=/etc/ssl --libdir=lib shared zlib-dynamic",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && sed -i '/INSTALL_LIBS/s/libcrypto.a libssl.a//' Makefile",
    f"cd {builddir} && make MANSUFFIX=ssl install",
    f"cd {builddir} && mv -v /usr/share/doc/openssl /usr/share/doc/openssl-{pkgver} || true",
    f"cd {builddir} && cp -vfr doc/* /usr/share/doc/openssl-{pkgver} && true",

    # 32-bit build
    f"cd {builddir} && make distclean",
    f"cd {builddir} && ./config --prefix=/usr --openssldir=/etc/ssl --libdir=lib32 shared zlib-dynamic linux-x86",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make DESTDIR=$PWD/DESTDIR install",
    f"cd {builddir} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd {builddir} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf {fembuilddir}"
]
