pkgname =  "ostree"
pkgver  = "2025.6" 
source  = f"https://github.com/ostreedev/ostree/releases/download/v{pkgver}/libostree-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/lib{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["fuse", "glib", "curl", "gpgme", "elogind"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/lib{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --sysconfdir=/etc --disable-static --with-curl --with-soup=no",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
