pkgname =  "p11-kit"
pkgver  = "0.25.10" 
source  = f"https://github.com/p11-glue/p11-kit/releases/download/{pkgver}/p11-kit-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed '20,$ d' -i trust/trust-extract-compat",
    f"""cd {builddir} && cat >> trust/trust-extract-compat << "EOF"
# Copy existing anchor modifications to /etc/ssl/local
/usr/libexec/make-ca/copy-trust-modifications

# Update trust stores
/usr/sbin/make-ca -r
EOF""",
    f"cd {builddir} && mkdir p11-build",
    f"cd {builddir}/p11-build && meson setup .. --prefix=/usr --buildtype=release -D trust_paths=/etc/pki/anchors",
    f"cd {builddir}/p11-build && ninja",
    f"cd {builddir}/p11-build && ninja install",
    f"cd {builddir}/p11-build && ln -sfv /usr/libexec/p11-kit/trust-extract-compat /usr/bin/update-ca-certificates || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
