pkgname =  "pango"
pkgver  = "1.57.0" 
source  = f"https://download.gnome.org/sources/pango/1.57/pango-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["fontconfig", "fribidi", "glib", "cairo", "xorg-libs"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release --wrap-mode=nofallback -D introspection=enabled ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
