pkgname =  "parted"
pkgver  = "3.6" 
source  = f"https://ftp.gnu.org/gnu/parted/parted-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["LVM2"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed -i 's/do_version ()/do_version (PedDevice** dev, PedDisk** diskp)/' parted/parted.c && ./configure --prefix=/usr --disable-static",
    f"cd {builddir} && make -j$(nproc) && make -C doc html && makeinfo --html -o doc/html doc/parted.texi && makeinfo --plaintext -o doc/parted.txt doc/parted.texi",
    f"cd {builddir} && make install && make && make -C doc html && makeinfo --html -o doc/html doc/parted.texi && makeinfo --plaintext -o doc/parted.txt doc/parted.texi",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
