# pcre2.recipe.py
pkgname = "pcre2"
pkgver  = "10.46"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
source  = f"https://github.com/PCRE2Project/pcre2/releases/download/pcre2-{pkgver}/pcre2-{pkgver}.tar.bz2"

deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --docdir=/usr/share/doc/pcre2-{pkgver} --enable-unicode --enable-jit --enable-pcre2-16 --enable-pcre2-32 --enable-pcre2grep-libz --enable-pcre2grep-libbz2 --enable-pcre2test-libreadline --disable-static",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Clean for 32-bit
    f"cd {builddir} && make distclean || true",
    f"cd {builddir} && rm -f config.log",

    # 32-bit build
    f"cd {builddir} && CC=\"gcc -m32\" CXX=\"g++ -m32\" ./configure --prefix=/usr --libdir=/usr/lib32 --host=i686-pc-linux-gnu --enable-unicode --enable-jit --enable-pcre2-16 --enable-pcre2-32 --enable-pcre2grep-libz --enable-pcre2grep-libbz2 --enable-pcre2test-libreadline --disable-static",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make DESTDIR=$PWD/DESTDIR install",
    f"cd {builddir} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd {builddir} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf {fembuilddir}"
]
