pkgname = "perl"
pkgver  = "5.42.0"
version = pkgver.split('.')[0] + '.' + pkgver.split('.')[1]
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && export BUILD_ZLIB=False && export BUILD_BZIP2=0 && sh Configure -des -D prefix=/usr -D vendorprefix=/usr -D privlib=/usr/lib/perl5/{version}/core_perl -D archlib=/usr/lib/perl5/{version}/core_perl -D sitelib=/usr/lib/perl5/{version}/site_perl -D sitearch=/usr/lib/perl5/{version}/site_perl -D vendorlib=/usr/lib/perl5/{version}/vendor_perl -D vendorarch=/usr/lib/perl5/{version}/vendor_perl -D man1dir=/usr/share/man/man1 -D man3dir=/usr/share/man/man3 -D pager=\"/usr/bin/less -isR\" -D useshrplib -D usethreads",
    f"cd /sources/{pkgname}-{pkgver} && export BUILD_ZLIB=False && export BUILD_BZIP2=0 && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && export BUILD_ZLIB=False && export BUILD_BZIP2=0 && make install",
    f"cd /sources/{pkgname}-{pkgver} && export BUILD_ZLIB=False && export BUILD_BZIP2=0 && unset BUILD_ZLIB BUILD_BZIP2",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
