# pkgconfig.recipe.py
pkgname = "pkgconf"
pkgver  = "2.5.1"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --disable-static --docdir=/usr/share/doc/pkgconf-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",
    f"cd /sources/{pkgname}-{pkgver} && ln -sv pkgconf   /usr/bin/pkg-config",
    f"cd /sources/{pkgname}-{pkgver} && ln -sv pkgconf.1 /usr/share/man/man1/pkg-config.1",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
