pkgname =  "pm-utils"
pkgver  = "1.4.1"
source  = f"https://pm-utils.freedesktop.org/releases/pm-utils-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz && wget https://www.linuxfromscratch.org/patches/blfs/svn/pm-utils-{pkgver}-bugfixes-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../pm-utils-{pkgver}-bugfixes-1.patch && ./configure --prefix=/usr --sysconfdir=/etc --docdir=/usr/share/doc/pm-utils-{pkgver}",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && install -v -m644 man/*.1 /usr/share/man/man1; install -v -m644 man/*.8 /usr/share/man/man8; ln -sv pm-action.8 /usr/share/man/man8/pm-suspend.8; ln -sv pm-action.8 /usr/share/man/man8/pm-hibernate.8; ln -sv pm-action.8 /usr/share/man/man8/pm-suspend-hybrid.8 && chmod +s /usr/sbin/pm-suspend",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
