pkgname =  "polkit-gnome"
pkgver  = "0.105" 
source  = f"https://download.gnome.org/sources/polkit-gnome/{pkgver}/polkit-gnome-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["accountsservice", "gtk3", "polkit"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz && wget https://www.linuxfromscratch.org/patches/blfs/svn/polkit-gnome-{pkgver}-consolidated_fixes-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../polkit-gnome-{pkgver}-consolidated_fixes-1.patch",
    f"cd {builddir} && ./configure --prefix=/usr",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
