pkgname =  "polkit-qt"
pkgver  = "0.200.0" 
source  = f"https://download.kde.org/stable/polkit-qt-1/polkit-qt-1-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/polkit-qt-1-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "polkit", "qt6"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/polkit-qt-1-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D QT_MAJOR_VERSION=6 -W no-dev ..",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
