pkgname =  "polkit"
pkgver  = "126" 
source  = f"https://github.com/polkit-org/polkit/archive/{pkgver}/polkit-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["ducktape", "glib", "Linux-PAM", "elogind"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D man=true -D session_tracking=elogind -D systemdsystemunitdir=/tmp -D tests=true",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && rm -v /tmp/*.service || true && rm -rf /usr/lib/{{sysusers,tmpfiles}}.d || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
