pkgname =  "pulseaudio"
pkgver  = "17.0" 
source  = f"https://www.freedesktop.org/software/pulseaudio/releases/pulseaudio-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libsndfile", "alsa-lib", "dbus", "elogind", "glib", "xorg-libs"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D database=gdbm -D doxygen=false -D bluez5=disabled -D tests=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && rm /usr/share/dbus-1/system.d/pulseaudio-system.conf",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
