pkgname = "python"
pkgver  = "3.14.0" 
Pkgver = pkgver[:4]
source  = f"https://www.python.org/ftp/python/{pkgver}/Python-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/Python-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/Python-{pkgver}.tar.xz",

    f"cd {builddir} && ./configure --prefix=/usr --enable-shared --with-system-expat --enable-optimizations --without-static-libpython",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && pip3 freeze > /var/lib/fempkg/old_python_modules.txt",
    f"cd {builddir} && make install",
    f"cd {builddir} && pip3 install requests build installer materialyoucolor pillow setupttools wheel",
    f"cd {builddir} && sudo find /usr/lib -maxdepth 1 -type d -name \"python3*\" ! -name \"python{Pkgver}\" -exec rm -rf {{}} +",
    f"cd {builddir} && echo -e \"[global]\\nroot-user-action = ignore\\ndisable-pip-version-check = true\" > /etc/pip.conf",
    f"""
python3 - <<'EOF'
import json
db_path = "/var/lib/fempkg/db.json"

def load_db():
    with open(db_path, "r") as f:
        return json.load(f)

def save_db(db):
    with open(db_path, "w") as f:
        json.dump(db, f, indent=4)

db = load_db()
pkgname = "caelestia-cli"
if pkgname in db.get("installed", {{}}):
    db["installed"].pop(pkgname)
    save_db(db)
EOF

cd /root && sudo rm -rf /usr/bin/caelestia && fempkg install caelestia-cli

# Always cleanup
rm -rf {fembuilddir}
"""
]