pkgname =  "pyyaml"
pkgver  = "6.0.3" 
source  = f"https://files.pythonhosted.org/packages/source/P/PyYAML/pyyaml-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cython", "libyaml"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD",
    f"cd {builddir} && pip3 install --no-index --find-links dist --force-reinstall --no-user PyYAML",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
