pkgname =  "qca"
pkgver  = "2.3.10" 
source  = f"https://download.kde.org/stable/qca/{pkgver}/qca-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "qt6", "which"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed -i 's@cert.pem@certs/ca-bundle.crt@' CMakeLists.txt && mkdir -v build && cd build && cmake -D CMAKE_INSTALL_PREFIX=$QT6DIR -D CMAKE_BUILD_TYPE=Release -D QT6=ON -D QCA_INSTALL_IN_QT_PREFIX=ON -D QCA_MAN_INSTALL_DIR:PATH=/usr/share/man ..",
    f"cd {builddir}/build && make -j$(nproca)",
    f"cd {builddir}/build && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
