# readline.recipe.py
pkgname = "readline"
pkgver  = "8.3"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && sed -i '/MV.*old/d' Makefile.in",
    f"cd /sources/{pkgname}-{pkgver} && sed -i '/{{OLDSUFF}}/c:' support/shlib-install",
    f"cd /sources/{pkgname}-{pkgver} && sed -i 's/-Wl,-rpath,[^ ]*//' support/shobj-conf",
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --disable-static --with-curses --docdir=/usr/share/doc/readline-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make SHLIB_LIBS=\"-lncursesw\" -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",
    f"cd /sources/{pkgname}-{pkgver} && install -v -m644 doc/*.{{ps,pdf,html,dvi}} /usr/share/doc/readline-{pkgver}",

    # Clean for 32-bit
    f"cd /sources/{pkgname}-{pkgver} && make distclean || true",
    f"cd /sources/{pkgname}-{pkgver} && rm -f config.log",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && CC=\"gcc -m32\" ./configure --host=i686-pc-linux-gnu --prefix=/usr --libdir=/usr/lib32 --disable-static --with-curses",
    f"cd /sources/{pkgname}-{pkgver} && make SHLIB_LIBS=\"-lncursesw\" -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make SHLIB_LIBS=\"-lncursesw\" DESTDIR=$PWD/DESTDIR install",
    f"cd /sources/{pkgname}-{pkgver} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd /sources/{pkgname}-{pkgver} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
